<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Model\ResourceModel;

use Magento\Framework\Model\ResourceModel\Db\AbstractDb;

class LoginAttributeCustomerValue extends AbstractDb
{
    public function _construct()
    {
        $this->_init('amasty_customer_login_attribute_customer_value', 'value_id');
    }

    /**
     * @param string $value
     * @param array $attributeIds
     * @return string|null
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function loadEmailByValue(string $value, array $attributeIds): ?string
    {
        $valueTable = $this->getMainTable();
        $customerTable = $this->getTable('customer_entity');

        $connection = $this->getConnection();

        $select = $connection->select()
            ->from(['v' => $valueTable], [])
            ->joinInner(['c' => $customerTable], 'v.customer_id = c.entity_id', ['c.email'])
            ->where('v.`value` = ?', $value)
            ->where('v.attribute_id IN(?)', $attributeIds);

        return (string)$connection->fetchOne($select);
    }
}
