<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Model\ResourceModel\LoginAttribute;

use Amasty\CustomerLoginAttributes\Model\LoginAttribute;
use Amasty\CustomerLoginAttributes\Model\ResourceModel\LoginAttribute as LoginAttributeResource;
use Magento\Framework\DataObject;
use Magento\Framework\Model\AbstractModel;
use Magento\Framework\Model\ResourceModel\Db\Collection\AbstractCollection;
use Magento\Store\Model\Store;

class Collection extends AbstractCollection
{
    protected function _construct()
    {
        $this->_init(
            LoginAttribute::class,
            LoginAttributeResource::class
        );
    }

    /**
     * Unserialize fields after loading
     *
     * @param DataObject $item
     * @return DataObject
     */
    protected function beforeAddLoadedItem(DataObject $item): DataObject
    {
        $resource = $this->getResource();
        if ($item instanceof AbstractModel) {
            $resource->unserializeFields($item);
        } elseif ($resource instanceof LoginAttributeResource) {
            $resource->unserializeFieldsInDataObject($item);
        }

        return parent::beforeAddLoadedItem($item);
    }

    /**
     * Join stores table and add filter by store
     * @param int $storeId
     * @return $this
     */
    public function addFilterByStore(int $storeId)
    {
        $this->join(
            ['cs' => $this->getTable(LoginAttributeResource::STORES_TABLE)],
            'main_table.attribute_id = cs.attribute_id'
        );

        $stores = [Store::DEFAULT_STORE_ID];

        if ($storeId) {
            $stores[] = $storeId;
        }

        $this->addFieldToFilter('cs.store_id', $stores);

        $this->getSelect()->group('main_table.attribute_id');
        return $this;
    }
}
