<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Model\QuoteValue;

use Amasty\CustomerLoginAttributes\Api\Data\LoginAttributeInterface;
use Amasty\CustomerLoginAttributes\Api\ValidateValueInterface;
use Amasty\CustomerLoginAttributes\Model\LoginAttribute\CollectionRegistry;
use Amasty\CustomerLoginAttributes\Model\ResourceModel\QuoteValue;
use Magento\Store\Model\StoreManagerInterface;

class SaveValuesForQuote
{
    /**
     * @var ValidateValueInterface
     */
    private $validateValue;

    /**
     * @var CollectionRegistry
     */
    private $collectionRegistry;

    /**
     * @var StoreManagerInterface
     */
    private $storeManager;

    /**
     * @var QuoteValue
     */
    private $resource;

    public function __construct(
        ValidateValueInterface $validateValue,
        CollectionRegistry $collectionRegistry,
        StoreManagerInterface $storeManager,
        QuoteValue $resource
    ) {
        $this->validateValue = $validateValue;
        $this->collectionRegistry = $collectionRegistry;
        $this->storeManager = $storeManager;
        $this->resource = $resource;
    }

    /**
     * @param int $cartId
     * @param \Amasty\CustomerLoginAttributes\Api\Data\ValueDataInterface[] $attributeValues
     * @return bool
     * @throws \Magento\Framework\Validator\Exception
     */
    public function save(int $cartId, array $attributeValues): bool
    {
        $this->validateValue->bulkValidate($attributeValues);

        $attributesData = [];
        foreach ($attributeValues as $attributeValue) {
            $attributesData[$attributeValue->getAttributeCode()] = $attributeValue->getValue();
        }

        $storeId = (int)$this->storeManager->getStore()->getId();
        $attributesCollection = $this->collectionRegistry->getCollectionFor(
            LoginAttributeInterface::IS_SHOW_ON_AMASTY_CHECKOUT
        )->addFilterByStore($storeId);

        $valuesForSave = [];
        /** @var LoginAttributeInterface $attribute */
        foreach ($attributesCollection->getItems() as $attribute) {
            $value = $attributesData[$attribute->getAttributeCode()] ?? null;

            if ($value) {
                $valuesForSave[] = [
                    'attribute_id' => $attribute->getAttributeId(),
                    'quote_id' => $cartId,
                    'value' => $value
                ];
            }
        }

        $this->resource->replaceValues($cartId, $valuesForSave);

        return true;
    }
}
