<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Model\QuoteValue;

use Amasty\CustomerLoginAttributes\Api\Data\ValueDataInterface;
use Amasty\CustomerLoginAttributes\Api\ValuesBulkSaveForQuoteInterface;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\Validator\Exception;
use Magento\Quote\Model\MaskedQuoteIdToQuoteIdInterface;

class SaveValuesForGuestQuote implements ValuesBulkSaveForQuoteInterface
{
    /**
     * @var SaveValuesForQuote
     */
    private $saveValuesForQuote;

    /**
     * @var MaskedQuoteIdToQuoteIdInterface
     */
    private $maskedQuoteIdToQuoteId;

    public function __construct(
        SaveValuesForQuote $saveValuesForQuote,
        MaskedQuoteIdToQuoteIdInterface $maskedQuoteIdToQuoteId
    ) {
        $this->saveValuesForQuote = $saveValuesForQuote;
        $this->maskedQuoteIdToQuoteId = $maskedQuoteIdToQuoteId;
    }

    /**
     * @param string $cartId
     * @param ValueDataInterface[] $attributeValues
     * @return bool
     * @throws NoSuchEntityException
     * @throws Exception
     */
    public function save(string $cartId, array $attributeValues): bool
    {
        $quoteId = $this->maskedQuoteIdToQuoteId->execute($cartId);
        
        return $this->saveValuesForQuote->save($quoteId, $attributeValues);
    }
}
