<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Model\QuoteValue;

use Amasty\CustomerLoginAttributes\Api\Data\LoginAttributeInterface;
use Amasty\CustomerLoginAttributes\Api\Data\QuoteValueInterface;
use Amasty\CustomerLoginAttributes\Api\Data\ValueDataInterface;
use Amasty\CustomerLoginAttributes\Api\Data\ValueDataInterfaceFactory;
use Amasty\CustomerLoginAttributes\Model\ResourceModel\QuoteValue\CollectionFactory;

class GetValuesForQuote
{
    /**
     * @var CollectionFactory
     */
    private $quoteValuesCollectionFactory;

    /**
     * @var ValueDataInterfaceFactory
     */
    private $valueDataFactory;

    /**
     * @var array
     */
    private $registry = [];

    public function __construct(
        CollectionFactory $quoteValuesCollectionFactory,
        ValueDataInterfaceFactory $valueDataFactory
    ) {
        $this->quoteValuesCollectionFactory = $quoteValuesCollectionFactory;
        $this->valueDataFactory = $valueDataFactory;
    }

    /**
     * Get saved login attribute values for quote
     *
     * @param int $quoteId
     * @return ValueDataInterface[]
     */
    public function get(int $quoteId): array
    {
        if (!isset($this->registry[$quoteId])) {
            $this->registry[$quoteId] = $this->getValues($quoteId);
        }

        return $this->registry[$quoteId];
    }

    /**
     * @param int $quoteId
     */
    public function clear(int $quoteId): void
    {
        unset($this->registry[$quoteId]);
    }

    /**
     * @param int $quoteId
     * @return ValueDataInterface[]
     */
    private function getValues(int $quoteId): array
    {
        $quoteValuesCollection = $this->quoteValuesCollectionFactory->create();

        $quoteValuesCollection->addFieldToFilter(QuoteValueInterface::QUOTE_ID, $quoteId);
        $quoteValuesCollection->addAttributesToSelect();

        $attributeValues = [];
        foreach ($quoteValuesCollection->getItems() as $quoteValue) {
            $attributeValue = $this->valueDataFactory->create();
            $attributeValue->setAttributeCode($quoteValue->getData(LoginAttributeInterface::ATTRIBUTE_CODE));
            $attributeValue->setValue($quoteValue->getValue());

            $attributeValues[] = $attributeValue;
        }

        return $attributeValues;
    }
}
