<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Model;

use Amasty\CustomerLoginAttributes\Api\Data\QuoteValueInterface;
use Amasty\CustomerLoginAttributes\Model\ResourceModel\QuoteValue as QuoteValueResource;
use Magento\Framework\Model\AbstractModel;

class QuoteValue extends AbstractModel implements QuoteValueInterface
{
    public function _construct()
    {
        $this->_init(QuoteValueResource::class);
    }

    /**
     * @return int
     */
    public function getValueId(): int
    {
        return (int)$this->getData(self::VALUE_ID);
    }

    /**
     * @param int $valueId
     * @return void
     */
    public function setValueId(int $valueId): void
    {
        $this->setData(self::VALUE_ID, $valueId);
    }

    /**
     * @return int
     */
    public function getAttributeId(): int
    {
        return (int)$this->getData(self::ATTRIBUTE_ID);
    }

    /**
     * @param int $attributeId
     * @return void
     */
    public function setAttributeId(int $attributeId): void
    {
        $this->setData(self::ATTRIBUTE_ID, $attributeId);
    }

    /**
     * @return int
     */
    public function getQuoteId(): int
    {
        return (int)$this->getData(self::QUOTE_ID);
    }

    /**
     * @param int $quoteId
     * @return void
     */
    public function setQuoteId(int $quoteId): void
    {
        $this->setData(self::QUOTE_ID, $quoteId);
    }

    /**
     * @return string
     */
    public function getValue(): string
    {
        return (string)$this->getData(self::VALUE);
    }

    /**
     * @param string $value
     * @return void
     */
    public function setValue(string $value): void
    {
        $this->setData(self::VALUE, $value);
    }
}
