<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Model\LoginAttributeCustomerValue;

use Amasty\CustomerLoginAttributes\Api\Data\LoginAttributeCustomerValueInterface;
use Amasty\CustomerLoginAttributes\Api\Data\LoginAttributeInterface;
use Amasty\CustomerLoginAttributes\Api\Data\ValueDataInterface;
use Amasty\CustomerLoginAttributes\Api\Data\ValueDataInterfaceFactory;
use Amasty\CustomerLoginAttributes\Api\ValueGetListInterface;
use Amasty\CustomerLoginAttributes\Model\ResourceModel\LoginAttributeCustomerValue\CollectionFactory;

class ValueGetList implements ValueGetListInterface
{
    /**
     * @var CollectionFactory
     */
    private $collectionFactory;

    /**
     * @var ValueDataInterfaceFactory
     */
    private $valueDataFactory;

    public function __construct(CollectionFactory $collectionFactory, ValueDataInterfaceFactory $valueDataFactory)
    {
        $this->collectionFactory = $collectionFactory;
        $this->valueDataFactory = $valueDataFactory;
    }

    /**
     * @param int $customerId
     * @return ValueDataInterface[]
     */
    public function getByCustomerId(int $customerId): array
    {
        $collection = $this->collectionFactory->create();

        $collection->addAttributesToSelect();
        $collection->addFieldToFilter(LoginAttributeCustomerValueInterface::CUSTOMER_ID, $customerId);

        $valueItems = [];
        /** @var LoginAttributeCustomerValueInterface $item */
        foreach ($collection->getItems() as $item) {
            $valueItem = $this->valueDataFactory->create();
            $valueItem->setValue($item->getValue());
            $valueItem->setAttributeCode($item->getData(LoginAttributeInterface::ATTRIBUTE_CODE));

            $valueItems[] = $valueItem;
        }

        return $valueItems;
    }
}
