<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Model\LoginAttributeCustomerValue;

use Amasty\CustomerLoginAttributes\Api\ValueBulkSaveInterface;
use Amasty\CustomerLoginAttributes\Api\ValueBulkSaveFromCustomerInterface;
use Magento\Customer\Model\AuthenticationInterface;
use Magento\Framework\Exception\AuthenticationException;
use Magento\Framework\Exception\InputException;

class ValueBulkSaveFromCustomer implements ValueBulkSaveFromCustomerInterface
{
    /**
     * @var AuthenticationInterface
     */
    private $authentication;

    /**
     * @var ValueBulkSaveInterface
     */
    private $valueBulkSave;

    public function __construct(
        AuthenticationInterface $authentication,
        ValueBulkSaveInterface $valueBulkSave
    ) {
        $this->authentication = $authentication;
        $this->valueBulkSave = $valueBulkSave;
    }

    /**
     * @param int $customerId
     * @param \Amasty\CustomerLoginAttributes\Api\Data\ValueDataInterface[] $attributesData
     * @param string $password
     * @return bool
     * @throws InputException|\Magento\Framework\Validator\Exception
     */
    public function save(int $customerId, array $attributesData, string $password): bool
    {
        try {
            $this->authentication->authenticate($customerId, $password);
        } catch (AuthenticationException $e) {
            throw new InputException(__('Invalid current password'));
        }

        return $this->valueBulkSave->save($customerId, $attributesData);
    }
}
