<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Model\LoginAttributeCustomerValue;

use Amasty\CustomerLoginAttributes\Api\ValueBulkSaveInterface;
use Amasty\CustomerLoginAttributes\Model\LoginAttributeCustomerValue\Formatter\BulkPhoneFormatter;
use Amasty\CustomerLoginAttributes\Model\LoginAttributeCustomerValue\Validator\BulkValidatorInterface;

class ValueBulkSave implements ValueBulkSaveInterface
{
    /**
     * @var BulkValidatorInterface
     */
    private $bulkValidator;

    /**
     * @var CustomerValuesUpdater
     */
    private $customerValuesSaver;

    /**
     * @var UnchangedValuesFilter
     */
    private $unchangedValuesFilter;

    /**
     * @var BulkPhoneFormatter
     */
    private $bulkPhoneFormatter;

    public function __construct(
        BulkValidatorInterface $bulkValidator,
        CustomerValuesUpdater $customerValuesSaver,
        UnchangedValuesFilter $unchangedValuesFilter,
        BulkPhoneFormatter $bulkPhoneFormatter
    ) {
        $this->bulkValidator = $bulkValidator;
        $this->customerValuesSaver = $customerValuesSaver;
        $this->unchangedValuesFilter = $unchangedValuesFilter;
        $this->bulkPhoneFormatter = $bulkPhoneFormatter;
    }

    /**
     * @param int $customerId
     * @param \Amasty\CustomerLoginAttributes\Api\Data\ValueDataInterface[] $attributesData
     * @return bool
     * @throws \Magento\Framework\Validator\Exception
     */
    public function save(int $customerId, array $attributesData): bool
    {
        $data = [];
        foreach ($attributesData as $item) {
            $data[$item->getAttributeCode()] = $item->getValue();
        }
        $data = $this->bulkPhoneFormatter->format($data);
        $data = $this->unchangedValuesFilter->filter($customerId, $data);
        $this->bulkValidator->validate($data);
        $this->customerValuesSaver->updateCustomerAttributes($customerId, $data);

        return true;
    }
}
