<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Model\LoginAttributeCustomerValue\Validator;

use Amasty\CustomerLoginAttributes\Api\Data\ValueDataInterface;
use Amasty\CustomerLoginAttributes\Api\ValidateValueInterface;
use Amasty\CustomerLoginAttributes\Model\LoginAttributeCustomerValue\Formatter\BulkPhoneFormatter;

class ValueValidator implements ValidateValueInterface
{
    /**
     * @var BulkValidatorInterface
     */
    private $bulkValidator;

    /**
     * @var BulkPhoneFormatter
     */
    private $bulkPhoneFormatter;

    public function __construct(BulkValidatorInterface $bulkValidator, BulkPhoneFormatter $bulkPhoneFormatter)
    {
        $this->bulkValidator = $bulkValidator;
        $this->bulkPhoneFormatter = $bulkPhoneFormatter;
    }

    /**
     * @param ValueDataInterface $attributeValue
     * @return bool
     * @throws \Magento\Framework\Validator\Exception
     */
    public function validate(ValueDataInterface $attributeValue): bool
    {
        $attributesData = [$attributeValue->getAttributeCode() => $attributeValue->getValue()];
        $attributesData = $this->bulkPhoneFormatter->format($attributesData);
        $this->bulkValidator->validate($attributesData);

        return true;
    }

    /**
     * @param \Amasty\CustomerLoginAttributes\Api\Data\ValueDataInterface[] $attributeValues
     * @return bool
     * @throws \Magento\Framework\Validator\Exception
     */
    public function bulkValidate(array $attributeValues): bool
    {
        $attributesData = [];
        foreach ($attributeValues as $attributeValue) {
            $attributesData[$attributeValue->getAttributeCode()] = $attributeValue->getValue();
        }

        $attributesData = $this->bulkPhoneFormatter->format($attributesData);
        $this->bulkValidator->validate($attributesData);

        return true;
    }
}
