<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Model\LoginAttributeCustomerValue\Validator;

use Magento\Framework\Validator\Exception as ValidatorException;

class ValueBulkValidator implements BulkValidatorInterface
{
    /**
     * @param array $attributesData
     * @throws ValidatorException
     */
    public function validate(array $attributesData): void
    {
        $errorMessages = [];
        foreach ($attributesData as $attributeValue) {
            if (empty($attributeValue)) {
                continue;
            }

            if (strpos($attributeValue, '@') !== false) {
                $errorMessages[] = __('"%1" must not contain symbol @', $attributeValue);
            }

        }

        if ($errorMessages) {
            $exception = new ValidatorException(null, null, [$errorMessages]);
            foreach ($errorMessages as $errorMessage) {
                $exception->addError($errorMessage);
            }
            throw $exception;
        }
    }
}
