<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Model\LoginAttributeCustomerValue\Validator;

use Amasty\CustomerLoginAttributes\Model\LoginAttributeCustomerValue\Formatter\CountryResolver;
use Amasty\CustomerLoginAttributes\Model\Wrapper\PhoneLibWrapper;

class PhoneValidator
{
    /**
     * @var PhoneLibWrapper
     */
    private $phoneLibWrapper;

    /**
     * @var CountryResolver
     */
    private $countryResolver;

    public function __construct(PhoneLibWrapper $phoneLibWrapper, CountryResolver $countryResolver)
    {
        $this->phoneLibWrapper = $phoneLibWrapper;
        $this->countryResolver = $countryResolver;
    }

    /**
     * @param string $phone
     * @param string|null $country
     * @return bool
     */
    public function isValid(string $phone, ?string $country = null): bool
    {
        if (!$country) {
            $country = $this->countryResolver->getCountry();
        }

        return $this->phoneLibWrapper->isValid($phone, $country);
    }
}
