<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Model\LoginAttributeCustomerValue\Validator;

use Amasty\CustomerLoginAttributes\Api\Data\LoginAttributeInterface;
use Amasty\CustomerLoginAttributes\Model\LoginAttributeCustomerValue\Formatter\PhoneFormatter;
use Amasty\CustomerLoginAttributes\Model\ResourceModel\LoginAttribute\CollectionFactory as AttributeCollectionFactory;
use Amasty\CustomerLoginAttributes\Model\Source\Option\AttributeTypeSource;
use Magento\Framework\Validator\Exception as ValidatorException;

class PhoneBulkValidator implements BulkValidatorInterface
{
    /**
     * @var AttributeCollectionFactory
     */
    private $attributeCollectionFactory;

    /**
     * @var PhoneValidator
     */
    private $phoneValidator;

    public function __construct(
        AttributeCollectionFactory $attributeCollectionFactory,
        PhoneValidator $phoneValidator
    ) {
        $this->attributeCollectionFactory = $attributeCollectionFactory;
        $this->phoneValidator = $phoneValidator;
    }

    /**
     * @param array $attributesData
     * @throws ValidatorException
     */
    public function validate(array $attributesData): void
    {
        $loginAttributesData = array_filter($attributesData);

        $attributesCollection = $this->attributeCollectionFactory->create();
        $attributesCollection->addFieldToFilter(LoginAttributeInterface::TYPE, AttributeTypeSource::TYPE_PHONE);
        $attributesCollection->addFieldToFilter(
            LoginAttributeInterface::ATTRIBUTE_CODE,
            ['in' => array_keys($loginAttributesData)]
        );
        $errorMessages = [];
        /** @var LoginAttributeInterface $item */
        foreach ($attributesCollection->getItems() as $item) {
            $value = $loginAttributesData[$item->getAttributeCode()];

            if (!$this->phoneValidator->isValid($value)) {
                $errorMessages[] = __('"%1" is not a valid phone number.', $value);
            }
        }
        if ($errorMessages) {
            $exception = new ValidatorException(null, null, [$errorMessages]);
            foreach ($errorMessages as $errorMessage) {
                $exception->addError($errorMessage);
            }
            throw $exception;
        }
    }
}
