<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Model\LoginAttributeCustomerValue\Validator;

use Magento\Framework\Validator\Exception as ValidatorException;

class LocalUniqueBulkValidator implements BulkValidatorInterface
{
    /**
     * @param array $attributesData
     * @throws ValidatorException
     */
    public function validate(array $attributesData): void
    {
        $existingValues = [];

        $errorMessages = [];
        foreach ($attributesData as $attributeValue) {
            if (empty($attributeValue)) {
                continue;
            }

            if (isset($existingValues[$attributeValue])) {
                $errorMessages[] = __('"%1" is used more than once', $attributeValue);
            }

            $existingValues[$attributeValue] = true;
        }

        if ($errorMessages) {
            $exception = new ValidatorException(null, null, [$errorMessages]);
            foreach ($errorMessages as $errorMessage) {
                $exception->addError($errorMessage);
            }
            throw $exception;
        }
    }
}
