<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Model\LoginAttributeCustomerValue\Validator;

use Amasty\CustomerLoginAttributes\Api\Data\LoginAttributeCustomerValueInterface;
use Amasty\CustomerLoginAttributes\Model\ResourceModel\LoginAttributeCustomerValue\CollectionFactory;
use Magento\Framework\Validator\Exception as ValidatorException;

class DbUniqueBulkValidator implements BulkValidatorInterface
{
    /**
     * @var CollectionFactory
     */
    private $collectionFactory;

    public function __construct(CollectionFactory $collectionFactory)
    {
        $this->collectionFactory = $collectionFactory;
    }

    /**
     * @param array $attributesData
     * @throws ValidatorException
     */
    public function validate(array $attributesData): void
    {
        $attributesData = array_filter($attributesData);
        $valuesForSearch = array_values($attributesData);

        $valuesCollection = $this->collectionFactory->create();
        $valuesCollection->addFieldToFilter(LoginAttributeCustomerValueInterface::VALUE, ['in' => $valuesForSearch]);

        $errorMessages = [];
        /** @var LoginAttributeCustomerValueInterface $attributeValue */
        foreach ($valuesCollection->getItems() as $attributeValue) {
            $errorMessages[] = __(
                '"%1" is already taken by another user.',
                $attributeValue->getValue()
            );
        }

        if ($errorMessages) {
            $exception = new ValidatorException(null, null, [$errorMessages]);
            foreach ($errorMessages as $errorMessage) {
                $exception->addError($errorMessage);
            }
            throw $exception;
        }
    }
}
