<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Model\LoginAttributeCustomerValue\Validator;

use Magento\Framework\Validator\Exception as ValidatorException;

class BulkValidatorComposite implements BulkValidatorInterface
{
    /**
     * @var BulkValidatorInterface[]
     */
    private $validators;

    public function __construct(array $validators)
    {
        $this->validators = $validators;
    }

    /**
     * @param array $attributesData
     * @throws ValidatorException
     */
    public function validate(array $attributesData): void
    {
        foreach ($this->validators as $validator) {
            if (!($validator instanceof BulkValidatorInterface)) {
                throw new \InvalidArgumentException(
                    sprintf(
                        'Validator %s must implement %s interface.',
                        get_class($validator),
                        BulkValidatorInterface::class
                    )
                );
            }
            
            $validator->validate($attributesData);
        }
    }
}
