<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Model\LoginAttributeCustomerValue;

use Amasty\CustomerLoginAttributes\Api\ValueGetListInterface;

class UnchangedValuesFilter
{
    /**
     * @var ValueGetListInterface
     */
    private $valueGetList;

    public function __construct(ValueGetListInterface $valueGetList)
    {
        $this->valueGetList = $valueGetList;
    }

    /**
     * Return only changed attributes data
     * @param int $customerId
     * @param array $loginAttributesData
     * @return array
     */
    public function filter(int $customerId, array $loginAttributesData): array
    {
        $currentValues = $this->valueGetList->getByCustomerId($customerId);
        foreach ($currentValues as $currentValue) {
            $attributeCode = $currentValue->getAttributeCode();
            $oldValue = $currentValue->getValue();
            $newValue = $loginAttributesData[$attributeCode] ?? null;

            // if no changes - remove from array without validation
            if ($oldValue === $newValue) {
                unset($loginAttributesData[$attributeCode]);
            }
        }

        return $loginAttributesData;
    }
}
