<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Model\LoginAttributeCustomerValue;

use Amasty\CustomerLoginAttributes\Api\Data\LoginAttributeCustomerValueInterface;
use Amasty\CustomerLoginAttributes\Api\ValueSaveInterface;
use Amasty\CustomerLoginAttributes\Model\ResourceModel\LoginAttributeCustomerValue;
use Magento\Framework\Exception\AlreadyExistsException;

class SaveCommand implements ValueSaveInterface
{
    /**
     * @var LoginAttributeCustomerValue
     */
    private $resource;

    public function __construct(LoginAttributeCustomerValue $resource)
    {
        $this->resource = $resource;
    }

    /**
     * @param LoginAttributeCustomerValueInterface $value
     * @return LoginAttributeCustomerValueInterface
     * @throws \Magento\Framework\Exception\AlreadyExistsException
     */
    public function save(LoginAttributeCustomerValueInterface $value): LoginAttributeCustomerValueInterface
    {
        try {
            $this->resource->save($value);
        } catch (AlreadyExistsException $e) {
            throw new AlreadyExistsException(__('Value %1 already exists'), $e);
        }

        return $value;
    }
}
