<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Model\LoginAttributeCustomerValue\Formatter;

use Amasty\CustomerLoginAttributes\Model\Wrapper\PhoneLibWrapper;

class PhoneFormatter
{
    /**
     * @var PhoneLibWrapper
     */
    private $phoneLibWrapper;

    /**
     * @var CountryResolver
     */
    private $countryResolver;

    public function __construct(PhoneLibWrapper $phoneLibWrapper, CountryResolver $countryResolver)
    {
        $this->phoneLibWrapper = $phoneLibWrapper;
        $this->countryResolver = $countryResolver;
    }

    /**
     * @param string $phone
     * @param string|null $country
     * @return string|null
     */
    public function formatPhoneToInternational(string $phone, ?string $country = null): ?string
    {
        if (!$country) {
            $country = $this->countryResolver->getCountry();
        }

        return $this->phoneLibWrapper->getInternationalNumber($phone, $country);
    }
}
