<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Model\LoginAttributeCustomerValue\Formatter;

use Amasty\CustomerLoginAttributes\Model\ConfigProvider;
use Amasty\CustomerLoginAttributes\Model\Wrapper\GeoipWrapper;

class CountryResolver
{
    /**
     * @var ConfigProvider
     */
    private $configProvider;

    /**
     * @var GeoipWrapper
     */
    private $geoipWrapper;

    public function __construct(
        ConfigProvider $configProvider,
        GeoipWrapper $geoipWrapper
    ) {
        $this->configProvider = $configProvider;
        $this->geoipWrapper = $geoipWrapper;
    }

    /**
     * @return string|null
     */
    public function getCountry(): ?string
    {
        $country = null;
        if ($this->configProvider->isUseGeoipForPhoneCountry()) {
            $country = $this->geoipWrapper->getCountry();
        }

        if (!$country) {
            $country = $this->configProvider->getDefaultPhoneCountry();
        }

        return $country;
    }
}
