<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Model\LoginAttributeCustomerValue\Formatter;

use Amasty\CustomerLoginAttributes\Api\Data\LoginAttributeInterface;
use Amasty\CustomerLoginAttributes\Model\LoginAttributeCustomerValue\Validator\PhoneValidator;
use Amasty\CustomerLoginAttributes\Model\ResourceModel\LoginAttribute\CollectionFactory as AttributeCollectionFactory;
use Amasty\CustomerLoginAttributes\Model\Source\Option\AttributeTypeSource;

class BulkPhoneFormatter
{
    /**
     * @var AttributeCollectionFactory
     */
    private $attributeCollectionFactory;

    /**
     * @var PhoneFormatter
     */
    private $phoneFormatter;

    /**
     * @var PhoneValidator
     */
    private $phoneValidator;

    public function __construct(
        AttributeCollectionFactory $attributeCollectionFactory,
        PhoneFormatter $phoneFormatter,
        PhoneValidator $phoneValidator
    ) {
        $this->attributeCollectionFactory = $attributeCollectionFactory;
        $this->phoneFormatter = $phoneFormatter;
        $this->phoneValidator = $phoneValidator;
    }

    /**
     * @param array $loginAttributesData
     * @return array
     */
    public function format(array $loginAttributesData): array
    {
        $filteredAttributes = array_filter($loginAttributesData);

        $attributesCollection = $this->attributeCollectionFactory->create();
        $attributesCollection->addFieldToFilter(LoginAttributeInterface::TYPE, AttributeTypeSource::TYPE_PHONE);
        $attributesCollection->addFieldToFilter(
            LoginAttributeInterface::ATTRIBUTE_CODE,
            ['in' => array_keys($filteredAttributes)]
        );
        /** @var LoginAttributeInterface $item */
        foreach ($attributesCollection->getItems() as $item) {
            $value = $loginAttributesData[$item->getAttributeCode()];

            $formattedPhone = null;
            if ($this->phoneValidator->isValid($value)) {
                $formattedPhone = $this->phoneFormatter->formatPhoneToInternational($value);
            }

            if ($formattedPhone) {
                $loginAttributesData[$item->getAttributeCode()] = $formattedPhone;
            }
        }

        return $loginAttributesData;
    }
}
