<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Model\LoginAttributeCustomerValue\Finder;

use Amasty\CustomerLoginAttributes\Api\Data\LoginAttributeInterface;
use Amasty\CustomerLoginAttributes\Model\ResourceModel\LoginAttributeCustomerValue;
use Amasty\CustomerLoginAttributes\Model\Source\Option\AttributeTypeSource;

class FindByTextAttributes implements FinderInterface
{
    /**
     * @var LoginAttributeCustomerValue
     */
    private $resource;

    public function __construct(LoginAttributeCustomerValue $resource)
    {
        $this->resource = $resource;
    }

    /**
     * @param LoginAttributeInterface[] $attributes
     * @param string $value
     * @return string|null
     */
    public function findByAttributes(array $attributes, string $value): ?string
    {
        $attributeIds = [];
        foreach ($attributes as $attribute) {
            if ($attribute->getType() === AttributeTypeSource::TYPE_TEXT) {
                $attributeIds[] = $attribute->getAttributeId();
            }
        }

        if (!$attributeIds) {
            return null;
        }

        return $this->resource->loadEmailByValue($value, $attributeIds);
    }
}
