<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Model\LoginAttributeCustomerValue\Finder;

use Amasty\CustomerLoginAttributes\Api\Data\LoginAttributeInterface;
use Amasty\CustomerLoginAttributes\Model\LoginAttributeCustomerValue\Formatter\PhoneFormatter;
use Amasty\CustomerLoginAttributes\Model\LoginAttributeCustomerValue\Validator\PhoneValidator;
use Amasty\CustomerLoginAttributes\Model\ResourceModel\LoginAttributeCustomerValue;
use Amasty\CustomerLoginAttributes\Model\Source\Option\AttributeTypeSource;

class FindByPhoneAttributes implements FinderInterface
{
    /**
     * @var LoginAttributeCustomerValue
     */
    private $resource;

    /**
     * @var PhoneFormatter
     */
    private $phoneFormatter;

    /**
     * @var PhoneValidator
     */
    private $phoneValidator;

    public function __construct(
        LoginAttributeCustomerValue $resource,
        PhoneFormatter $phoneFormatter,
        PhoneValidator $phoneValidator
    ) {
        $this->resource = $resource;
        $this->phoneFormatter = $phoneFormatter;
        $this->phoneValidator = $phoneValidator;
    }

    /**
     * @param LoginAttributeInterface[] $attributes
     * @param string $value
     * @return string|null
     */
    public function findByAttributes(array $attributes, string $value): ?string
    {
        $attributeIds = [];
        foreach ($attributes as $attribute) {
            if ($attribute->getType() === AttributeTypeSource::TYPE_PHONE) {
                $attributeIds[] = $attribute->getAttributeId();
            }
        }

        if (!$attributeIds) {
            return null;
        }

        if (!$this->phoneValidator->isValid($value)) {
            return null;
        }

        $formattedPhone = $this->phoneFormatter->formatPhoneToInternational($value);

        return $this->resource->loadEmailByValue($formattedPhone, $attributeIds);
    }
}
