<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Model\LoginAttributeCustomerValue;

use Amasty\CustomerLoginAttributes\Model\LoginAttribute\AllowedLoginAttributes;
use Amasty\CustomerLoginAttributes\Model\LoginAttributeCustomerValue\Finder\FinderInterface;
use Psr\Log\LoggerInterface;

class FindEmailService
{
    /**
     * @var AllowedLoginAttributes
     */
    private $allowedLoginAttributes;

    /**
     * @var LoggerInterface
     */
    private $logger;

    /**
     * @var FinderInterface[]
     */
    private $finders;

    public function __construct(
        AllowedLoginAttributes $allowedLoginAttributes,
        LoggerInterface $logger,
        array $finders
    ) {
        $this->allowedLoginAttributes = $allowedLoginAttributes;
        $this->logger = $logger;
        $this->finders = $finders;
    }

    /**
     * @param string $value
     * @param int $storeId
     * @return string|null
     */
    public function findByValue(string $value, int $storeId): ?string
    {
        $attributes = $this->allowedLoginAttributes->getAllowedAttributes($storeId);

        $email = null;
        foreach ($this->finders as $finder) {
            try {
                $email = $finder->findByAttributes($attributes, $value);
            } catch (\Throwable $e) {
                $this->logger->critical($e);
            }

            if ($email) {
                break;
            }
        }

        return empty($email) ? null : $email;
    }
}
