<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Model\LoginAttributeCustomerValue;

use Amasty\CustomerLoginAttributes\Api\Data\LoginAttributeCustomerValueInterface;
use Amasty\CustomerLoginAttributes\Api\ValueDeleteInterface;
use Amasty\CustomerLoginAttributes\Model\ResourceModel\LoginAttributeCustomerValue;

class DeleteCommand implements ValueDeleteInterface
{
    /**
     * @var LoginAttributeCustomerValue
     */
    private $resource;

    public function __construct(LoginAttributeCustomerValue $resource)
    {
        $this->resource = $resource;
    }

    /**
     * @param LoginAttributeCustomerValueInterface $value
     * @return bool
     */
    public function delete(LoginAttributeCustomerValueInterface $value): bool
    {
        $this->resource->delete($value);

        return true;
    }
}
