<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Model\LoginAttributeCustomerValue\Data;

use Amasty\CustomerLoginAttributes\Api\Data\ValueDataInterface;
use Magento\Framework\Api\AbstractSimpleObject;

class ValueData extends AbstractSimpleObject implements ValueDataInterface
{
    /**
     * @return string
     */
    public function getValue(): string
    {
        return (string)$this->_get(self::VALUE);
    }

    /**
     * @param string $value
     */
    public function setValue(string $value): void
    {
        $this->setData(self::VALUE, $value);
    }

    /**
     * @return string
     */
    public function getAttributeCode(): string
    {
        return (string)$this->_get(self::ATTRIBUTE_CODE);
    }

    /**
     * @param string $attributeCode
     */
    public function setAttributeCode(string $attributeCode): void
    {
        $this->setData(self::ATTRIBUTE_CODE, $attributeCode);
    }
}
