<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Model\LoginAttributeCustomerValue\Converter;

use Amasty\CustomerLoginAttributes\Api\Data\ValueDataInterface;
use Amasty\CustomerLoginAttributes\Api\Data\ValueDataInterfaceFactory;

class ArrayToObjectsConverter
{
    /**
     * @var ValueDataInterfaceFactory
     */
    private $valueDataFactory;

    public function __construct(
        ValueDataInterfaceFactory $valueDataFactory
    ) {
        $this->valueDataFactory = $valueDataFactory;
    }

    /**
     * @param ValueDataInterface[] $attributesData
     * @return array
     */
    public function convert(array $attributesData): array
    {
        $items = [];
        foreach ($attributesData as $attributeCode => $attributeValue) {
            $item = $this->valueDataFactory->create();
            $item->setAttributeCode((string)$attributeCode);
            $item->setValue((string)$attributeValue);

            $items[] = $item;
        }

        return $items;
    }
}
