<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Model;

use Amasty\CustomerLoginAttributes\Api\Data\LoginAttributeCustomerValueInterface;
use Magento\Framework\Model\AbstractModel;

class LoginAttributeCustomerValue extends AbstractModel implements LoginAttributeCustomerValueInterface
{
    public function _construct()
    {
        $this->_init(\Amasty\CustomerLoginAttributes\Model\ResourceModel\LoginAttributeCustomerValue::class);
    }

    public function getValueId(): int
    {
        return (int)$this->getData(self::VALUE_ID);
    }

    public function setValueId(int $id): void
    {
        $this->setData(self::VALUE_ID, $id);
    }

    public function getAttributeId(): int
    {
        return (int)$this->getData(self::ATTRIBUTE_ID);
    }

    public function setAttributeId(int $attributeId): void
    {
        $this->setData(self::ATTRIBUTE_ID, $attributeId);
    }

    public function getCustomerId(): int
    {
        return (int)$this->getData(self::CUSTOMER_ID);
    }

    public function setCustomerId(int $customerId): void
    {
        $this->setData(self::CUSTOMER_ID, $customerId);
    }

    public function getValue(): string
    {
        return (string)$this->getData(self::VALUE);
    }

    public function setValue(string $value): void
    {
        $this->setData(self::VALUE, $value);
    }
}
