<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Model\LoginAttribute;

use Amasty\CustomerLoginAttributes\Api\Data\LoginAttributeInterface;
use Amasty\CustomerLoginAttributes\Api\LoginAttributeSaveInterface;
use Amasty\CustomerLoginAttributes\Model\ResourceModel\LoginAttribute;
use Magento\Framework\Exception\CouldNotSaveException;
use Magento\Framework\Exception\InputException;
use Magento\Framework\Exception\LocalizedException;
use Psr\Log\LoggerInterface;

class SaveCommand implements LoginAttributeSaveInterface
{
    /**
     * @var LoginAttribute
     */
    private $resource;

    /**
     * @var LoggerInterface
     */
    private $logger;

    /**
     * @var Validator
     */
    private $validator;

    public function __construct(LoginAttribute $resource, LoggerInterface $logger, Validator $validator)
    {
        $this->resource = $resource;
        $this->logger = $logger;
        $this->validator = $validator;
    }

    /**
     * @param LoginAttributeInterface $attribute
     * @param array $storeIds
     * @return LoginAttributeInterface
     * @throws CouldNotSaveException
     * @throws InputException
     * @throws LocalizedException
     */
    public function save(LoginAttributeInterface $attribute, array $storeIds): LoginAttributeInterface
    {
        $this->validator->validate($attribute);

        try {
            $this->resource->saveWithStores($attribute, $storeIds);
        } catch (LocalizedException $e) {
            throw $e;
        } catch (\Exception $exception) {
            $this->logger->critical($exception);
            throw new CouldNotSaveException(__('Something went wrong while saving the attribute.'));
        }

        return $attribute;
    }
}
