<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Model\LoginAttribute;

use Amasty\CustomerLoginAttributes\Api\Data\LoginAttributeInterface;
use Amasty\CustomerLoginAttributes\Api\Data\LoginAttributeInterfaceFactory;
use Amasty\CustomerLoginAttributes\Api\LoginAttributeGetInterface;
use Amasty\CustomerLoginAttributes\Model\ResourceModel\LoginAttribute;
use Magento\Framework\Exception\NoSuchEntityException;

class LoginAttributeGet implements LoginAttributeGetInterface
{
    /**
     * @var LoginAttribute
     */
    private $resource;

    /**
     * @var LoginAttributeInterfaceFactory
     */
    private $factory;

    public function __construct(
        LoginAttribute $resource,
        LoginAttributeInterfaceFactory $factory
    ) {
        $this->resource = $resource;
        $this->factory = $factory;
    }

    /**
     * @param int $id
     * @return LoginAttributeInterface
     * @throws NoSuchEntityException
     */
    public function get(int $id): LoginAttributeInterface
    {
        $model = $this->factory->create();
        $this->resource->load($model, $id);

        if (!$model->getAttributeId()) {
            throw new NoSuchEntityException(__('Attribute with id %1 doesn\'t exists', $id));
        }

        return $model;
    }

    /**
     * @param string $code
     * @return LoginAttributeInterface
     * @throws NoSuchEntityException
     */
    public function getByCode(string $code): LoginAttributeInterface
    {
        $model = $this->factory->create();
        $this->resource->load($model, $code, LoginAttributeInterface::ATTRIBUTE_CODE);

        if (!$model->getAttributeId()) {
            throw new NoSuchEntityException(__('Attribute with code %1 doesn\'t exists', $code));
        }

        return $model;
    }

    /**
     * @param int $id
     * @return int[] list of store ids
     */
    public function getStoreIds(int $id): array
    {
        $storeIds = $this->resource->loadStores($id);

        foreach ($storeIds as &$storeId) {
            $storeId = (int)$storeId;
        }

        return $storeIds;
    }
}
