<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Model\LoginAttribute;

use Amasty\CustomerLoginAttributes\Api\Data\LoginAttributeInterface;

class LabelProvider
{
    /**
     * Get Login Attribute label according to Store
     * @param LoginAttributeInterface $loginAttribute
     * @param int $storeId
     * @return string
     */
    public function getLabelForStore(LoginAttributeInterface $loginAttribute, int $storeId): string
    {
        $storeLabels = $loginAttribute->getStoreLabels();

        return !empty($storeLabels[$storeId]) ? $storeLabels[$storeId] : $loginAttribute->getLabel();
    }
}
