<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Model\LoginAttribute;

use Amasty\CustomerLoginAttributes\Api\LoginAttributeDeleteInterface;
use Amasty\CustomerLoginAttributes\Api\LoginAttributeGetInterface;
use Amasty\CustomerLoginAttributes\Model\ResourceModel\LoginAttribute;
use Magento\Framework\Exception\CouldNotDeleteException;

class DeleteCommand implements LoginAttributeDeleteInterface
{
    /**
     * @var LoginAttribute
     */
    private $resource;

    /**
     * @var LoginAttributeGetInterface
     */
    private $loginAttributeGet;

    public function __construct(LoginAttribute $resource, LoginAttributeGetInterface $loginAttributeGet)
    {
        $this->resource = $resource;
        $this->loginAttributeGet = $loginAttributeGet;
    }

    /**
     * @param int $id
     * @return bool
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     * @throws \Magento\Framework\Exception\CouldNotDeleteException
     */
    public function deleteById(int $id): bool
    {
        $model = $this->loginAttributeGet->get($id);

        try {
            $this->resource->delete($model);
        } catch (\Throwable $e) {
            throw new CouldNotDeleteException(__('Something went wring with deleting attribute id %'), $id, $e);
        }

        return true;
    }
}
