<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Model\LoginAttribute;

use Amasty\CustomerLoginAttributes\Api\Data\LoginAttributeInterface;
use Amasty\CustomerLoginAttributes\Api\LoginAttributeGetInterface;
use Amasty\CustomerLoginAttributes\Model\ResourceModel\LoginAttribute\Collection;
use Amasty\CustomerLoginAttributes\Model\ResourceModel\LoginAttribute\CollectionFactory;
use Magento\Framework\App\Request\DataPersistorInterface;
use Magento\Ui\DataProvider\Modifier\PoolInterface;

class DataProvider extends \Magento\Ui\DataProvider\ModifierPoolDataProvider
{
    /**
     * @var Collection
     */
    protected $collection;

    /**
     * @var DataPersistorInterface
     */
    private $dataPersistor;

    /**
     * @var array
     */
    private $loadedData;

    /**
     * @var LoginAttributeGetInterface
     */
    private $loginAttributeGet;

    /**
     * @var PoolInterface|null
     */
    private $pool;

    public function __construct(
        $name,
        $primaryFieldName,
        $requestFieldName,
        CollectionFactory $collectionFactory,
        DataPersistorInterface $dataPersistor,
        LoginAttributeGetInterface $loginAttributeGet,
        PoolInterface $pool,
        array $meta = [],
        array $data = []
    ) {
        $this->collection = $collectionFactory->create();
        $this->dataPersistor = $dataPersistor;
        $this->loginAttributeGet = $loginAttributeGet;
        $this->pool = $pool;
        parent::__construct($name, $primaryFieldName, $requestFieldName, $meta, $data, $pool);
    }

    /**
     * Get data
     *
     * @return array
     */
    public function getData()
    {
        if (isset($this->loadedData)) {
            return $this->loadedData;
        }
        $this->loadedData = [];
        $items = $this->collection->getItems();
        /** @var LoginAttributeInterface $attribute */
        foreach ($items as $attribute) {
            $id = $attribute->getAttributeId();
            $this->loadedData[$id] = $attribute->getData();
            $this->loadedData[$id]['store_id'] = implode(',', $this->loginAttributeGet->getStoreIds($id));
            $this->loadedData[$id]['is_edit'] = true;
        }

        $data = $this->dataPersistor->get('am_customer_login_attribute');
        if (!empty($data)) {
            $attribute = $this->collection->getNewEmptyItem();
            $attribute->setData($data);
            $id = $attribute->getAttributeId() ?: null;
            $this->loadedData[$id] = $attribute->getData();
            $this->dataPersistor->clear('am_customer_login_attribute');
            $this->loadedData[$id]['is_edit'] = (bool)$id;
        }

        foreach ($this->pool->getModifiersInstances() as $modifier) {
            $this->loadedData = $modifier->modifyData($this->loadedData);
        }

        return $this->loadedData;
    }
}
