<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Model\LoginAttribute;

use Amasty\CustomerLoginAttributes\Api\Data\LoginAttributeInterface;
use Amasty\CustomerLoginAttributes\Model\ResourceModel\LoginAttribute\Collection;
use Amasty\CustomerLoginAttributes\Model\ResourceModel\LoginAttribute\CollectionFactory;

class CollectionRegistry
{
    /**
     * @var CollectionFactory
     */
    private $collectionFactory;

    /**
     * @var array array("condition_field" => Collection)
     */
    private $collections = [];

    public function __construct(CollectionFactory $collectionFactory)
    {
        $this->collectionFactory = $collectionFactory;
    }

    /**
     * @param string $conditionPlaceField
     * @return Collection
     */
    public function getCollectionFor(string $conditionPlaceField): Collection
    {
        if (!isset($this->collections[$conditionPlaceField])) {
            $this->collections[$conditionPlaceField] = $this->createCollection($conditionPlaceField);
        }

        return $this->collections[$conditionPlaceField];
    }

    /**
     * @param string $conditionPlaceField
     * @return Collection
     */
    private function createCollection(string $conditionPlaceField): Collection
    {
        $collection = $this->collectionFactory->create();
        $collection->addFieldToFilter($conditionPlaceField, 1);
        $collection->addOrder(LoginAttributeInterface::SORT_ORDER, Collection::SORT_ORDER_ASC);

        return $collection;
    }
}
