<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Model\LoginAttribute;

use Amasty\CustomerLoginAttributes\Api\Data\LoginAttributeInterface;
use Amasty\CustomerLoginAttributes\Model\ConfigProvider;
use Amasty\CustomerLoginAttributes\Model\ResourceModel\LoginAttribute\CollectionFactory;

class AllowedLoginAttributes
{
    /**
     * @var CollectionFactory
     */
    private $collectionFactory;

    /**
     * @var ConfigProvider
     */
    private $configProvider;

    public function __construct(CollectionFactory $collectionFactory, ConfigProvider $configProvider)
    {
        $this->collectionFactory = $collectionFactory;
        $this->configProvider = $configProvider;
    }

    /**
     * Get allowed to login attributes ids for store
     * @param int $storeId
     * @return LoginAttributeInterface[]
     */
    public function getAllowedAttributes(int $storeId): array
    {
        $collection = $this->collectionFactory->create();
        $collection->addFilterByStore($storeId);
        $allowedAttributeCodes = $this->configProvider->getLoginAttributes();

        $collection->addFieldToFilter(
            LoginAttributeInterface::ATTRIBUTE_CODE,
            $allowedAttributeCodes
        );

        return $collection->getItems();
    }
}
