<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Model;

use Amasty\CustomerLoginAttributes\Api\Data\LoginAttributeInterface;

class LoginAttribute extends \Magento\Framework\Model\AbstractModel implements LoginAttributeInterface
{
    /**
     * Init Model
     */
    public function _construct()
    {
        $this->_init(\Amasty\CustomerLoginAttributes\Model\ResourceModel\LoginAttribute::class);
    }

    /**
     * @return int
     */
    public function getAttributeId(): int
    {
        return (int)$this->getData(self::ATTRIBUTE_ID);
    }

    /**
     * @param int $attributeId
     */
    public function setAttributeId(int $attributeId): void
    {
        $this->setData(self::ATTRIBUTE_ID, $attributeId);
    }

    /**
     * @return string
     */
    public function getAttributeCode(): string
    {
        return (string)$this->getData(self::ATTRIBUTE_CODE);
    }

    /**
     * @param string $attributeCode
     */
    public function setAttributeCode(string $attributeCode): void
    {
        $this->setData(self::ATTRIBUTE_CODE, $attributeCode);
    }

    /**
     * @return string
     */
    public function getType(): string
    {
        return (string)$this->getData(self::TYPE);
    }

    /**
     * @param string $type
     */
    public function setType(string $type): void
    {
        $this->setData(self::TYPE, $type);
    }

    /**
     * @return string
     */
    public function getLabel(): string
    {
        return (string)$this->getData(self::LABEL);
    }

    /**
     * @param string $label
     */
    public function setLabel(string $label): void
    {
        $this->setData(self::LABEL, $label);
    }

    /**
     * @return bool
     */
    public function isRequired(): bool
    {
        return (bool)$this->getData(self::IS_REQUIRED);
    }

    /**
     * @param bool $isRequired
     */
    public function setIsRequired(bool $isRequired): void
    {
        $this->setData(self::IS_REQUIRED, $isRequired);
    }

    /**
     * @return string
     */
    public function getInputValidation(): string
    {
        return (string)$this->getData(self::INPUT_VALIDATION);
    }

    /**
     * @param string $inputValidation
     */
    public function setInputValidation(string $inputValidation): void
    {
        $this->setData(self::INPUT_VALIDATION, $inputValidation);
    }

    /**
     * @return bool
     */
    public function isShowOnCustomerGrid(): bool
    {
        return (bool)$this->getData(self::IS_SHOW_ON_CUSTOMER_GRID);
    }

    /**
     * @param bool $isShowOnCustomerGrid
     */
    public function setIsShowOnCustomerGrid(bool $isShowOnCustomerGrid): void
    {
        $this->setData(self::IS_SHOW_ON_CUSTOMER_GRID, $isShowOnCustomerGrid);
    }

    /**
     * @return bool
     */
    public function isShowOnOrderGrid(): bool
    {
        return (bool)$this->getData(self::IS_SHOW_ON_ORDER_GRID);
    }

    /**
     * @param bool $isShowOnOrderGrid
     */
    public function setIsShowOnOrderGrid(bool $isShowOnOrderGrid): void
    {
        $this->setData(self::IS_SHOW_ON_ORDER_GRID, $isShowOnOrderGrid);
    }

    /**
     * @return bool
     */
    public function isShowOnOrderView(): bool
    {
        return (bool)$this->getData(self::IS_SHOW_ON_ORDER_VIEW);
    }

    /**
     * @param bool $isShowOnOrderView
     */
    public function setIsShowOnOrderView(bool $isShowOnOrderView): void
    {
        $this->setData(self::IS_SHOW_ON_ORDER_VIEW, $isShowOnOrderView);
    }

    /**
     * @return bool
     */
    public function isShowOnCustomerAccount(): bool
    {
        return (bool)$this->getData(self::IS_SHOW_ON_CUSTOMER_ACCOUNT);
    }

    /**
     * @param bool $isShowOnCustomerAccount
     */
    public function setIsShowOnCustomerAccount(bool $isShowOnCustomerAccount): void
    {
        $this->setData(self::IS_SHOW_ON_CUSTOMER_ACCOUNT, $isShowOnCustomerAccount);
    }

    /**
     * @return bool
     */
    public function isShowOnRegistration(): bool
    {
        return (bool)$this->getData(self::IS_SHOW_ON_REGISTRATION);
    }

    /**
     * @param bool $isShowOnRegistration
     */
    public function setIsShowOnRegistration(bool $isShowOnRegistration): void
    {
        $this->setData(self::IS_SHOW_ON_REGISTRATION, $isShowOnRegistration);
    }
    
    /**
     * @return bool
     */
    public function isShowOnAmastyCheckout(): bool
    {
        return (bool)$this->getData(self::IS_SHOW_ON_AMASTY_CHECKOUT);
    }

    /**
     * @param bool $isShowOnAmastyCheckout
     */
    public function setIsShowOnAmastyCheckout(bool $isShowOnAmastyCheckout): void
    {
        $this->setData(self::IS_SHOW_ON_AMASTY_CHECKOUT, $isShowOnAmastyCheckout);
    }

    /**
     * @return int
     */
    public function getSortOrder(): int
    {
        return (int)$this->getData(self::SORT_ORDER);
    }

    /**
     * @param int $sortOrder
     */
    public function setSortOrder(int $sortOrder): void
    {
        $this->setData(self::SORT_ORDER, $sortOrder);
    }

    /**
     * @return array
     */
    public function getStoreLabels(): array
    {
        return $this->getData(self::STORE_LABELS);
    }

    /**
     * @param array $labels
     */
    public function setStoreLabels(array $labels): void
    {
        $this->setData(self::STORE_LABELS, $labels);
    }

    /**
     * @return string
     */
    public function getPlaceholder(): string
    {
        return (string)$this->getData(self::PLACEHOLDER);
    }

    /**
     * @param string $placeholder
     */
    public function setPlaceholder(string $placeholder): void
    {
        $this->setData(self::PLACEHOLDER, $placeholder);
    }
}
