<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Model;

use Amasty\CustomerLoginAttributes\Model\Source\Option\LoginAttributes;

class EnabledValidator
{
    /**
     * @var ConfigProvider
     */
    private $configProvider;

    public function __construct(ConfigProvider $configProvider)
    {
        $this->configProvider = $configProvider;
    }

    /**
     * Is login via custom login attributes enabled
     * @return bool
     */
    public function isEnabled(): bool
    {
        $loginAttributes = $this->configProvider->getLoginAttributes();

        if (!$loginAttributes) {
            return false;
        }

        return !(count($loginAttributes) === 1 && $loginAttributes[0] === LoginAttributes::EMAIL);
    }

    /**
     * @return bool
     */
    public function isEmailLoginEnabled(): bool
    {
        $loginAttributes = $this->configProvider->getLoginAttributes();

        return in_array(LoginAttributes::EMAIL, $loginAttributes, true);
    }
}
