<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Model;

use Amasty\Base\Model\ConfigProviderAbstract;

class ConfigProvider extends ConfigProviderAbstract
{
    /**
     * xpath prefix of module (section)
     * @var string '{section}/'
     */
    protected $pathPrefix = 'amcustomerloginattr/';

    public const LOGIN_ATTRIBUTES = 'login/attributes';
    public const IS_NEW_FIELD_TITLE = 'login/is_new_field_title_on_login_page';
    public const NEW_FIELD_TITLE = 'login/field_title_on_login_page';
    public const IS_NEW_NOTICE = 'login/is_new_notice_on_login_page';
    public const NEW_NOTICE = 'login/notice_on_login_page';
    public const IS_ATTRIBUTE_NOTICE = 'login/is_add_attribute_notice';
    public const ATTRIBUTE_NOTICE = 'login/attribute_notice';
    public const DEFAULT_PHONE_COUNTRY = 'login/default_phone_country';
    public const USE_GEOIP_FOR_PHONE_COUNTRY = 'login/use_geoip_for_phone_country';

    /**
     * List of login attributes
     * @return array
     */
    public function getLoginAttributes(): array
    {
        $value = $this->getValue(self::LOGIN_ATTRIBUTES);

        return explode(',', $value);
    }

    /**
     * @return bool
     */
    public function isNewLoginFieldTitle(): bool
    {
        return $this->isSetFlag(self::IS_NEW_FIELD_TITLE);
    }

    /**
     * @return string
     */
    public function getNewLoginFieldTitle(): string
    {
        return (string)$this->getValue(self::NEW_FIELD_TITLE);
    }

    /**
     * @return bool
     */
    public function isNewLoginNotice(): bool
    {
        return $this->isSetFlag(self::IS_NEW_NOTICE);
    }

    /**
     * @return string
     */
    public function getNewLoginNotice(): string
    {
        return (string)$this->getValue(self::NEW_NOTICE);
    }

    /**
     * @return bool
     */
    public function isAttributeNotice(): bool
    {
        return $this->isSetFlag(self::IS_ATTRIBUTE_NOTICE);
    }

    /**
     * @return string
     */
    public function getAttributeNotice(): string
    {
        return (string)$this->getValue(self::ATTRIBUTE_NOTICE);
    }

    /**
     * @return string|null
     */
    public function getDefaultPhoneCountry(): ?string
    {
        return $this->getValue(self::DEFAULT_PHONE_COUNTRY);
    }

    /**
     * @return bool
     */
    public function isUseGeoipForPhoneCountry(): bool
    {
        return $this->isSetFlag(self::USE_GEOIP_FOR_PHONE_COUNTRY);
    }
}
