<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Controller\Adminhtml\Attribute;

use Amasty\CustomerLoginAttributes\Api\Data\LoginAttributeInterfaceFactory;
use Amasty\CustomerLoginAttributes\Api\LoginAttributeGetInterface;
use Amasty\CustomerLoginAttributes\Api\LoginAttributeSaveInterface;
use Magento\Backend\App\Action\Context;
use Magento\Framework\App\Action\HttpPostActionInterface;
use Magento\Framework\App\Request\DataPersistorInterface;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Exception\NoSuchEntityException;

class Save extends \Magento\Backend\App\Action implements HttpPostActionInterface
{
    /**
     * Authorization level of a basic admin session
     *
     * @see _isAllowed()
     */
    public const ADMIN_RESOURCE = 'Amasty_CustomerLoginAttributes::attributes_manage';

    /**
     * @var DataPersistorInterface
     */
    private $dataPersistor;

    /**
     * @var LoginAttributeInterfaceFactory
     */
    private $loginAttributeFactory;

    /**
     * @var LoginAttributeGetInterface
     */
    private $loginAttributeGet;

    /**
     * @var LoginAttributeSaveInterface
     */
    private $loginAttributeSave;

    public function __construct(
        Context $context,
        DataPersistorInterface $dataPersistor,
        LoginAttributeInterfaceFactory $loginAttributeFactory,
        LoginAttributeGetInterface $loginAttributeGet,
        LoginAttributeSaveInterface $loginAttributeSave
    ) {
        parent::__construct($context);
        $this->dataPersistor = $dataPersistor;
        $this->loginAttributeFactory = $loginAttributeFactory;
        $this->loginAttributeGet = $loginAttributeGet;
        $this->loginAttributeSave = $loginAttributeSave;
    }

    public function execute()
    {
        $resultRedirect = $this->resultRedirectFactory->create();
        $data = $this->getRequest()->getPostValue();

        if ($data) {
            $model = $this->loginAttributeFactory->create();
            $id = $this->getRequest()->getParam('attribute_id');

            if ($id) {
                try {
                    $model = $this->loginAttributeGet->get((int)$id);
                } catch (NoSuchEntityException $e) {
                    $this->messageManager->addErrorMessage($e->getMessage());

                    return $resultRedirect->setPath('*/*/');
                }
            } else {
                unset($data['attribute_id']);
            }

            $model->setData($data);

            try {
                $this->loginAttributeSave->save($model, $data['store_id']);
                $this->messageManager->addSuccessMessage(__('You saved the attribute.'));
                $this->dataPersistor->clear('am_customer_login_attribute');

                $back = $data['back'] ?? 'close';

                if ($back === 'continue') {
                    $resultRedirect->setPath('*/*/edit', ['attribute_id' => $model->getAttributeId()]);
                } else {
                    $resultRedirect->setPath('*/*/');
                }

                return $resultRedirect;
            } catch (LocalizedException $e) {
                $this->messageManager->addErrorMessage($e->getMessage());
            } catch (\Exception $e) {
                $this->messageManager->addExceptionMessage($e, __('Something went wrong while saving the attribute.'));
            }

            $this->dataPersistor->set('am_customer_login_attribute', $data);
            return $resultRedirect->setPath('*/*/edit', ['attribute_id' => $id]);
        }

        return $resultRedirect->setPath('*/*/');
    }
}
