<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Controller\Adminhtml\Attribute;

use Magento\Backend\App\Action\Context;
use Magento\Framework\App\Action\HttpGetActionInterface;

class Index extends \Magento\Backend\App\Action implements HttpGetActionInterface
{
    /**
     * Authorization level of a basic admin session
     *
     * @see _isAllowed()
     */
    public const ADMIN_RESOURCE = 'Amasty_CustomerLoginAttributes::attributes_manage';

    /**
     * @var \Magento\Framework\View\Result\PageFactory
     */
    private $resultPageFactory;

    public function __construct(Context $context, \Magento\Framework\View\Result\PageFactory $resultPageFactory)
    {
        parent::__construct($context);
        $this->resultPageFactory = $resultPageFactory;
    }

    /**
     * @return \Magento\Backend\Model\View\Result\Page
     */
    public function execute()
    {
        /** @var \Magento\Backend\Model\View\Result\Page $resultPage */
        $resultPage = $this->resultPageFactory->create();
        $resultPage->setActiveMenu('Amasty_CustomerLoginAttributes::attributes')
            ->addBreadcrumb(__('Customer'), __('Customer'))
            ->addBreadcrumb(__('Login Attributes'), __('Login Attributes'));
        $resultPage->getConfig()->getTitle()->prepend(__('Login Attributes'));

        return $resultPage;
    }
}
