<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Controller\Adminhtml\Attribute;

use Amasty\CustomerLoginAttributes\Api\LoginAttributeGetInterface;
use Magento\Backend\App\Action\Context;
use Magento\Framework\App\Action\HttpGetActionInterface;
use Magento\Framework\Exception\NoSuchEntityException;

class Edit extends \Magento\Backend\App\Action implements HttpGetActionInterface
{
    /**
     * Authorization level of a basic admin session
     *
     * @see _isAllowed()
     */
    public const ADMIN_RESOURCE = 'Amasty_CustomerLoginAttributes::attributes_manage';

    /**
     * @var \Magento\Framework\View\Result\PageFactory
     */
    private $resultPageFactory;

    /**
     * @var LoginAttributeGetInterface
     */
    private $loginAttributeGet;

    public function __construct(
        Context $context,
        \Magento\Framework\View\Result\PageFactory $resultPageFactory,
        LoginAttributeGetInterface $loginAttributeGet
    ) {
        parent::__construct($context);
        $this->resultPageFactory = $resultPageFactory;
        $this->loginAttributeGet = $loginAttributeGet;
    }

    /**
     * @return \Magento\Backend\Model\View\Result\Page|\Magento\Backend\Model\View\Result\Redirect
     */
    public function execute()
    {
        $id = (int)$this->getRequest()->getParam('attribute_id');

        if ($id) {
            try {
                $this->loginAttributeGet->get($id);
            } catch (NoSuchEntityException $e) {
                $this->messageManager->addErrorMessage(__('This Attribute does not exist.'));

                /** @var \Magento\Backend\Model\View\Result\Redirect $resultRedirect */
                $resultRedirect = $this->resultRedirectFactory->create();
                $resultRedirect->setPath('*/*/');

                return $resultRedirect;
            }
        }

        /** @var \Magento\Backend\Model\View\Result\Page $resultPage */
        $resultPage = $this->resultPageFactory->create();
        $resultPage->setActiveMenu('Amasty_CustomerLoginAttributes::attributes')
            ->addBreadcrumb(__('Customer'), __('Customer'))
            ->addBreadcrumb(__('Login Attributes'), __('Login Attributes'));
        $resultPage->getConfig()->getTitle()->prepend(
            $id ? __('Edit Login Attribute') : __('New Login Attribute')
        );

        return $resultPage;
    }
}
