<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Controller\Adminhtml\Attribute;

use Amasty\CustomerLoginAttributes\Api\LoginAttributeDeleteInterface;
use Magento\Backend\App\Action\Context;
use Magento\Framework\App\Action\HttpPostActionInterface;
use Magento\Framework\Exception\LocalizedException;

class Delete extends \Magento\Backend\App\Action implements HttpPostActionInterface
{
    /**
     * Authorization level of a basic admin session
     *
     * @see _isAllowed()
     */
    public const ADMIN_RESOURCE = 'Amasty_CustomerLoginAttributes::attributes_manage';

    /**
     * @var LoginAttributeDeleteInterface
     */
    private $attributeDelete;

    public function __construct(Context $context, LoginAttributeDeleteInterface $attributeDelete)
    {
        parent::__construct($context);
        $this->attributeDelete = $attributeDelete;
    }

    /**
     * Delete action
     *
     * @return \Magento\Framework\Controller\ResultInterface
     */
    public function execute()
    {
        /** @var \Magento\Backend\Model\View\Result\Redirect $resultRedirect */
        $resultRedirect = $this->resultRedirectFactory->create();
        $id = $this->getRequest()->getParam('attribute_id');
        if ($id) {
            try {
                $this->attributeDelete->deleteById((int)$id);
                $this->messageManager->addSuccessMessage(__('You deleted the attribute.'));

                return $resultRedirect->setPath('*/*/');
            } catch (LocalizedException $e) {
                $this->messageManager->addErrorMessage($e->getMessage());

                return $resultRedirect->setPath('*/*/edit', ['attribute_id' => $id]);
            } catch (\Exception $e) {
                $this->messageManager->addExceptionMessage($e, __('Something went wrong with deleting this attribute'));

                return $resultRedirect->setPath('*/*/edit', ['attribute_id' => $id]);
            }
        }
        $this->messageManager->addErrorMessage(__('We can\'t find a block to delete.'));

        return $resultRedirect->setPath('*/*/');
    }
}
