<?php
declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Block\Adminhtml\Attribute\Listing;

use Magento\Framework\Module\Manager;
use Magento\Framework\UrlInterface;
use Magento\Framework\View\Element\UiComponent\Control\ButtonProviderInterface;

class CustomerAttributesButton implements ButtonProviderInterface
{
    public const CA_MODULE_CODE = 'Amasty_CustomerAttributes';

    /**
     * @var UrlInterface
     */
    private $urlBuilder;

    /**
     * @var Manager
     */
    private $moduleManager;

    public function __construct(
        UrlInterface $urlBuilder,
        Manager $moduleManager
    ) {
        $this->urlBuilder = $urlBuilder;
        $this->moduleManager = $moduleManager;
    }

    /**
     * @return array
     */
    public function getButtonData(): array
    {
        if ($this->moduleManager->isEnabled(self::CA_MODULE_CODE)) {
            return [
                'label' => __('Customer Attributes'),
                'on_click' => sprintf("location.href = '%s';", $this->getUrl()),
                'class' => 'customer_attributes',
                'sort_order' => 10
            ];
        }

        return [];
    }

    /**
     * @return string
     */
    public function getUrl(): string
    {
        return $this->urlBuilder->getUrl('amcustomerattr/attribute/index');
    }
}
