<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Block\Adminhtml\Attribute\Edit;

use Magento\Backend\Block\Widget\Context;
use Magento\Framework\View\Element\UiComponent\Control\ButtonProviderInterface;

class DeleteButton implements ButtonProviderInterface
{
    /**
     * @var Context
     */
    private $context;

    public function __construct(Context $context)
    {
        $this->context = $context;
    }

    /**
     * @return array
     */
    public function getButtonData(): array
    {
        $data = [];
        if ($this->getAttributeId()) {
            $data = [
                'label' => __('Delete Attribute'),
                'class' => 'delete',
                'on_click' => 'deleteConfirm(\'' . __('Are you sure you want to do this?')
                    . '\', \'' . $this->getDeleteUrl() . '\', {"data": {}})',
                'sort_order' => 20,
            ];
        }

        return $data;
    }

    /**
     * URL to send delete requests to.
     *
     * @return string
     */
    public function getDeleteUrl(): string
    {
        return $this->context->getUrlBuilder()->getUrl('*/*/delete', ['attribute_id' => $this->getAttributeId()]);
    }

    /**
     * @return int
     */
    public function getAttributeId(): int
    {
        $attributeId = $this->context->getRequest()->getParam('attribute_id');

        return (int)$attributeId;
    }
}
