<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Api;

use Magento\Framework\Exception\InputException;

interface ValueBulkSaveFromCustomerInterface
{
    /**
     * @param int $customerId
     * @param \Amasty\CustomerLoginAttributes\Api\Data\ValueDataInterface[] $attributesData
     * @param string $password
     * @return bool
     * @throws InputException|\Magento\Framework\Validator\Exception
     */
    public function save(int $customerId, array $attributesData, string $password): bool;
}
