<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Api;

/**
 * Validate value or values for login attribute/attributes
 * @api
 */
interface ValidateValueInterface
{
    /**
     * @param \Amasty\CustomerLoginAttributes\Api\Data\ValueDataInterface $attributeValue
     * @return bool
     * @throws \Magento\Framework\Validator\Exception
     */
    public function validate(\Amasty\CustomerLoginAttributes\Api\Data\ValueDataInterface $attributeValue): bool;

    /**
     * @param \Amasty\CustomerLoginAttributes\Api\Data\ValueDataInterface[] $attributeValues
     * @return bool
     * @throws \Magento\Framework\Validator\Exception
     */
    public function bulkValidate(array $attributeValues): bool;
}
