<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Api;

interface LoginAttributeGetInterface
{
    /**
     * @param int $id
     * @return \Amasty\CustomerLoginAttributes\Api\Data\LoginAttributeInterface
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function get(int $id): \Amasty\CustomerLoginAttributes\Api\Data\LoginAttributeInterface;

    /**
     * @param string $code
     * @return \Amasty\CustomerLoginAttributes\Api\Data\LoginAttributeInterface
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function getByCode(string $code): \Amasty\CustomerLoginAttributes\Api\Data\LoginAttributeInterface;

    /**
     * @param int $id
     * @return int[]
     */
    public function getStoreIds(int $id): array;
}
