<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Api\Data;

/**
 * Data interface for attributes' values
 *
 * @api
 */
interface ValueDataInterface
{
    public const ATTRIBUTE_CODE = 'attribute_code';
    public const VALUE = 'value';

    /**
     * @return string
     */
    public function getValue(): string;

    /**
     * @param string $value
     */
    public function setValue(string $value): void;

    /**
     * @return string
     */
    public function getAttributeCode(): string;

    /**
     * @param string $attributeCode
     */
    public function setAttributeCode(string $attributeCode): void;
}
