<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Api\Data;

interface QuoteValueInterface
{
    public const VALUE_ID = 'value_id';
    public const ATTRIBUTE_ID = 'attribute_id';
    public const QUOTE_ID = 'quote_id';
    public const VALUE = 'value';

    /**
     * @return int
     */
    public function getValueId(): int;

    /**
     * @param int $valueId
     * @return void
     */
    public function setValueId(int $valueId): void;

    /**
     * @return int
     */
    public function getAttributeId(): int;

    /**
     * @param int $attributeId
     * @return void
     */
    public function setAttributeId(int $attributeId): void;

    /**
     * @return int
     */
    public function getQuoteId(): int;

    /**
     * @param int $quoteId
     * @return void
     */
    public function setQuoteId(int $quoteId): void;

    /**
     * @return string
     */
    public function getValue(): string;

    /**
     * @param string $value
     * @return void
     */
    public function setValue(string $value): void;
}
