<?php

declare(strict_types=1);

namespace Amasty\CustomerLoginAttributes\Api\Data;

interface LoginAttributeInterface
{
    public const ATTRIBUTE_ID = 'attribute_id';
    public const ATTRIBUTE_CODE = 'attribute_code';
    public const TYPE = 'type';
    public const LABEL = 'label';
    public const IS_REQUIRED = 'is_required';
    public const INPUT_VALIDATION = 'input_validation';
    public const IS_SHOW_ON_CUSTOMER_GRID = 'is_show_on_customer_grid';
    public const IS_SHOW_ON_ORDER_GRID = 'is_show_on_order_grid';
    public const IS_SHOW_ON_ORDER_VIEW = 'is_show_on_order_view';
    public const IS_SHOW_ON_CUSTOMER_ACCOUNT = 'is_show_on_customer_account';
    public const IS_SHOW_ON_REGISTRATION = 'is_show_on_registration';
    public const IS_SHOW_ON_AMASTY_CHECKOUT = 'is_show_on_amasty_checkout';
    public const SORT_ORDER = 'sort_order';
    public const STORE_LABELS = 'store_labels';
    public const PLACEHOLDER = 'placeholder';

    /**
     * @return int
     */
    public function getAttributeId(): int;

    /**
     * @param int $attributeId
     * @return void
     */
    public function setAttributeId(int $attributeId): void;

    /**
     * @return string
     */
    public function getAttributeCode(): string;

    /**
     * @param string $attributeCode
     * @return void
     */
    public function setAttributeCode(string $attributeCode): void;

    /**
     * @return string
     */
    public function getType(): string;

    /**
     * @param string $type
     * @return void
     */
    public function setType(string $type): void;

    /**
     * @return string
     */
    public function getLabel(): string;

    /**
     * @param string $label
     * @return void
     */
    public function setLabel(string $label): void;

    /**
     * @return bool
     */
    public function isRequired(): bool;

    /**
     * @param bool $isRequired
     * @return void
     */
    public function setIsRequired(bool $isRequired): void;

    /**
     * @return string
     */
    public function getInputValidation(): string;

    /**
     * @param string $inputValidation
     * @return void
     */
    public function setInputValidation(string $inputValidation): void;

    /**
     * @return bool
     */
    public function isShowOnCustomerGrid(): bool;

    /**
     * @param bool $isShowOnCustomerGrid
     * @return void
     */
    public function setIsShowOnCustomerGrid(bool $isShowOnCustomerGrid): void;

    /**
     * @return bool
     */
    public function isShowOnOrderGrid(): bool;

    /**
     * @param bool $isShowOnOrderGrid
     * @return void
     */
    public function setIsShowOnOrderGrid(bool $isShowOnOrderGrid): void;

    /**
     * @return bool
     */
    public function isShowOnOrderView(): bool;

    /**
     * @param bool $isShowOnOrderView
     * @return void
     */
    public function setIsShowOnOrderView(bool $isShowOnOrderView): void;

    /**
     * @return bool
     */
    public function isShowOnCustomerAccount(): bool;

    /**
     * @param bool $isShowOnCustomerAccount
     * @return void
     */
    public function setIsShowOnCustomerAccount(bool $isShowOnCustomerAccount): void;

    /**
     * @return bool
     */
    public function isShowOnRegistration(): bool;

    /**
     * @param bool $isShowOnRegistration
     * @return void
     */
    public function setIsShowOnRegistration(bool $isShowOnRegistration): void;

    /**
     * @return bool
     */
    public function isShowOnAmastyCheckout(): bool;

    /**
     * @param bool $isShowOnAmastyCheckout
     * @return void
     */
    public function setIsShowOnAmastyCheckout(bool $isShowOnAmastyCheckout): void;

    /**
     * @return int
     */
    public function getSortOrder(): int;

    /**
     * @param int $sortOrder
     * @return void
     */
    public function setSortOrder(int $sortOrder): void;

    /**
     * @return array array("storeId" => "label")
     */
    public function getStoreLabels(): array;

    /**
     * @param array $labels
     * @return void
     */
    public function setStoreLabels(array $labels): void;

    /**
     * @return string
     */
    public function getPlaceholder(): string;

    /**
     * @param string $placeholder
     * @return void
     */
    public function setPlaceholder(string $placeholder): void;
}
